//+---------------------------------------------------------------------------------+
//+ MA2_Signal                                                                      +
//+     2-                                   +
//+                                                                                 +
//+  :                                                              +
//+  ExtPeriodFastMA -                                           +
//+  ExtPeriodSlowMA -                                        +
//+  ExtModeFastMA   -                                            +
//+  ExtModeSlowMA   -                                         +
//+   : 0 = SMA, 1 = EMA, 2 = SMMA (), 3 = LWMA ()        +
//+  ExtPriceFastMA  -                                             +
//+  ExtPriceSlowMA  -                                          +
//+   : 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = HL/2, 5 = HLC/3, 6 = HLCC/4 +
//+---------------------------------------------------------------------------------+
#property copyright ""
#property link      ""

//----  
#property indicator_chart_window
#property indicator_buffers 4
//---- 
#property indicator_color1 Magenta // 5
#property indicator_color2 Blue        // 7
#property indicator_color3 MediumBlue
#property indicator_color4 Tomato

//---- 
extern int    ExtPeriodFastMA = 5;
extern int    ExtPeriodSlowMA = 7;
extern int    ExtModeFastMA   = 1; // 0 = SMA, 1 = EMA, 2 = SMMA, 3 = LWMA
extern int    ExtModeSlowMA   = 1; // 0 = SMA, 1 = EMA, 2 = SMMA, 3 = LWMA
extern int    ExtPriceFastMA  = 0; // 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = HL/2, 5 = HLC/3, 6 = HLCC/4
extern int    ExtPriceSlowMA  = 1; // 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = HL/2, 5 = HLC/3, 6 = HLCC/4
extern string ExtSoundFileName = "";
extern bool ActiveSignal=true;
extern double NormalizeAccuracy = 0.0000;


//---- 
double FastMA[];
double SlowMA[];
double CrossUp[];
double CrossDown[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
  //----   
  //     
  SetIndexStyle( 0, DRAW_LINE );
  SetIndexStyle( 1, DRAW_LINE );
  //     
  SetIndexStyle( 2, DRAW_ARROW, EMPTY );
  SetIndexArrow( 2, 233 );
  SetIndexStyle( 3, DRAW_ARROW, EMPTY );
  SetIndexArrow( 3, 234 );
  //----  
  SetIndexBuffer( 0, FastMA    );
  SetIndexBuffer( 1, SlowMA    );
  SetIndexBuffer( 2, CrossUp   );
  SetIndexBuffer( 3, CrossDown );
  
  IndicatorDigits( MarketInfo( Symbol(), MODE_DIGITS ) );
  
  //----   
  IndicatorShortName( "MA2_Signal(" + ExtPeriodFastMA + "," + ExtPeriodSlowMA );
  SetIndexLabel( 0, "MA" + ExtPeriodFastMA );
  SetIndexLabel( 1, "MA" + ExtPeriodSlowMA );
  SetIndexLabel( 2, "Buy"  );
  SetIndexLabel( 3, "Sell" );
  
  return ( 0 );
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
  static bool bBuy  = False;
  static bool bSell = False;
    
  bool   bConditionUp;
  bool   bConditionDown;
  double Range;
  double AvgRange;
  int    iLimit;
  int    i;
  int    counter;
  int    counted_bars = IndicatorCounted();
  
  
  //---- check for possible errors
  if ( counted_bars < 0 ) 
    return ( -1 );
  
  //---- last counted bar will be recounted
  if ( counted_bars > 0 ) counted_bars--;
  
  iLimit = Bars - counted_bars;
  
  for ( i = 0; i <= iLimit; i++ ) {
    FastMA[i] = iMA( NULL, 0, ExtPeriodFastMA, 0, ExtModeFastMA, ExtPriceFastMA, i );
    SlowMA[i] = iMA( NULL, 0, ExtPeriodSlowMA, 0, ExtModeSlowMA, ExtPriceSlowMA, i );
  } 
  
  for ( i = 1; i <= iLimit; i++ ) {
    AvgRange = 0;
    for ( counter = i; counter <= i + 9; counter++ ) {
      AvgRange += MathAbs( High[ counter ] - Low[ counter ] );
    }
    Range = AvgRange/10;
    
    /*if ( i == 0 ) {
      bConditionUp   = ( FastMA[i  ] > SlowMA[i  ] ) &&
                       ( FastMA[i+1] < SlowMA[i+1] ); //   
      bConditionDown = ( FastMA[i  ] < SlowMA[i  ] ) &&
                       ( FastMA[i+1] > SlowMA[i+1] ); //  
    }
    else {*/
      bConditionUp   = ( FastMA[i] >= SlowMA[i] ) &&
                       ( FastMA[i+1] <= SlowMA[i+1] ) &&
                       ( FastMA[i-1] >= SlowMA[i-1] )&& //  
                       ( NormalizeDouble(FastMA[i-1]- FastMA[i+1],4)>=NormalizeAccuracy);
      bConditionDown = ( FastMA[i] <= SlowMA[i] ) &&
                       ( FastMA[i+1] >= SlowMA[i+1] ) &&
                       ( FastMA[i-1] <= SlowMA[i-1] ) && //  
                       ( NormalizeDouble(FastMA[i+1]- FastMA[i-1],4)>=NormalizeAccuracy);
    //} 
    
    
                       
                       
    
    if ( bConditionUp )
    CrossUp[i] = Low[i] - Range * 0.5;
    else if ( bConditionDown )
    CrossDown[i] = High[i] + Range * 0.5;
    
    if ( !bBuy && bConditionUp ) {
      // 
      bBuy  = True;  //   
      bSell = False; //   
      
      // 
      
      if ( i < 2 && ActiveSignal == True ) {
         Alert (Symbol()," ",Period(),"M  Achtung BUY "); //  
        if ( ExtSoundFileName != "" )
          PlaySound( ExtSoundFileName );
      } 
      
    }
    else if ( !bSell && bConditionDown ) {
      // 
      bSell = True;  //   
      bBuy  = False; //   
      
      // 
      
      if ( i < 2 && ActiveSignal == True) {
        Alert (Symbol()," ",Period(),"M   Achtung SELL "); //  
        if ( ExtSoundFileName != "" )
          PlaySound( ExtSoundFileName );
      } 
    } 
  } 
 return ( 0 );
}